#!/opt/perl/bin/perl -w
# Template for perl scripts
# Provide the architecture for what is usually needed in a script
# All this template does is write the content of an input file
# to the output file - copy and change this script as desired
#
# This code copyright 2002-2003 by
# D. W. Eaton, Artronic Development, Phoenix, AZ -- dwe@arde.com
#
# This software is made freely available under the provisions of the Perl
# "Artistic" license:  http://language.perl.com/misc/Artistic.html
#
# This code is not supported and is not warranteed to perform any particular
# function. Contact dwe@arde.com for aditional information.
# If you find bugs or make enhancements, it would be appreciated if you
# sent them on to the author at dwe@arde.com.
#
# Logical revision history:
#  1.2 -  DWE Add ability to default output to STDOUT
#  1.1 -  DWE More sanitization
#  1.0 -  DWE Initial version
#
# Pragmas
use strict;
#
BEGIN
{
 # Could set module libs here, for example:
 # unshift (@INC, '/opt/template/lib/utilities');
}

# Environment
use Getopt::Long;
# In some environments, modules exist to define common items, use it:
##use Constants;

# Define local data
# Variables:
my (
$all,
$arg1,
$bakext,
$defaultSTDOUT,
$ercf_noinfile,
$ercf_noinread,
$ercf_noopmake,
$ercf_opexist,
$ercf_ok,
$ercf_user,
$false,
$inputext,
$line,
$lineno,
$lines,
$numargs,
$opt_help,
$opt_in,
$opt_keep,
$opt_out,
$opt_outdir,
$opt_quiet,
$opt_replace,
$opt_showerror,
$opt_syntax,
$opt_verbose,
$opt_version,
$opt_veryverbose,
$opt_veryveryverbose,
$outleaf,
$outline,
$outlinecnt,
$outpext,
$outpfile,
$progname,
$replacedefault,
$status,
$true,
$userid,
$versn
);
# Arrays:
my (
@content,
@opts,
@inpfile
);
# Hashes:
my (
%ermcf,
%opt
);

# These should come from "Constants" utility module:
$true  = 1;  # truth values
$false = 0;
$all   = 2; # for Getopt ignore case
use vars ('$true','$false','$all');
#
# Program configuration 'constants':
$versn = '1.2 - 20 DEC 2002';
#
# Exit status codes:
$ercf_ok = 0;$ermcf{$ercf_ok} = 'Exit OK';
$ercf_noinfile = 1;$ermcf{$ercf_noinfile} = 'Can\'t find input file';
$ercf_noinread = 2;$ermcf{$ercf_noinread} = 'Can\'t read input file';
$ercf_noopmake = 3;$ermcf{$ercf_noopmake} = 'Can\'t create new output file';
$ercf_opexist = 4;$ermcf{$ercf_opexist} = 'Output file already exists';
$ercf_user = 99;$ermcf{$ercf_user} = 'User syntax error';
#
$| = $true; # Don't buffer output
#
# Some more-like configuration items:
# Default for the --replace option ($true or $false)
# $false requires the user to supply --replace to overwrite output
# $true always overwrites output without asking for confirm
$replacedefault = $true; # Default for the --replace option
# Default for the --out option ($true or $false)
# $false allows output as described elsewhere
# $true always writes to STDOUT unless user specifies an output
$defaultSTDOUT = $false;
#
$inputext = 'txt'; # Default input name extension
$outpext = 'out'; # Default output name extension
$bakext = 'bak'; # Extension to use for backup of input file (if needed)
#
# Specific configurable values:
# (add your configuration items here)
# ---- end normal configuration items --------------------
#
# Specific initialization:
# (add your initialization items here)
#
# Try to determine user name
$userid = getlogin || getpwuid ($<) || $ENV{'USER'} || $ENV{'LOGNAME'};

if (! defined ($userid))
{
 die "Can't figure out the user name!\n";
}
#
chomp ($progname = `basename $0`); # Get our leaf name
#
# Process command line
$opt_help = 'help';
$opt_in = 'in';
$opt_keep = 'keep';
$opt_out = 'out';
$opt_outdir = 'outdir';
$opt_quiet = 'quiet';
$opt_replace = 'replace';
$opt_showerror = 'showerror';
$opt_syntax = 'syntax';
$opt_verbose = 'verbose';
$opt_version = 'version';
$opt_veryverbose = 'veryverbose';
$opt_veryveryverbose = 'veryveryverbose';
#
$opt{$opt_help}        = $false;  # defaults
$opt{$opt_in}          = '';
$opt{$opt_keep}        = $false;
$opt{$opt_out}         = '';
$opt{$opt_outdir}      = '';
$opt{$opt_quiet}       = $false;
$opt{$opt_replace}     = $replacedefault;
$opt{$opt_showerror}   = $false;
$opt{$opt_syntax}      = $false;
$opt{$opt_verbose}     = $false;
$opt{$opt_version}     = $false;
$opt{$opt_veryverbose} = $false;
$opt{$opt_veryveryverbose} = $false;
#
# Initialize accepted options:
@opts = qw(
  help|h
  in=s
  keep|k
  out=s
  outdir|outd=s
  quiet|q
  replace|r
  showerror|shoerr|se|e
  syntax
  verbose|v
  version
  veryverbose|vv
  veryveryverbose|vvv
);
#
# Process command-line
$Getopt::Long::bundling = $true;  # perl 5.003 and earlier will complain about this
$Getopt::Long::ignorecase = $all;
GetOptions (\%opt, @opts);
#
# Check supplied options:
if ($opt{$opt_veryveryverbose})
{
 # Force veryverbose (if it was not already called out)
 $opt{$opt_veryverbose} = $true;
}
#
if ($opt{$opt_veryverbose})
{
 # Force verbose (if it was not already called out)
 $opt{$opt_verbose} = $true;
}
#
$numargs = scalar (@ARGV); # Number of non-option arguments left
if ($opt{$opt_version})
{
 print STDERR "$progname v$versn\n";
 exit ($ercf_user); # Quit after showing version
}
#
if ($opt{$opt_help} || $opt{$opt_syntax})
{
 &syntax_message ();
 exit ($ercf_user);
}
if ($opt{$opt_showerror})
{
 &show_error_codes(%ermcf); # Sho error codes
 exit ($ercf_user);
}
#
# ----------
#
# Check rest of arguments
#
# Look for an input file name
# Get non-option arguments (one at most):
if ($numargs == 1)
{
 if ($opt{$opt_in})
 {
  # Argh, we can't tollerate multiple input designations
  print STDERR "ERROR: use positional or specific input designation, use --$opt_help for assistance\n";
  exit ($ercf_user);
 }
 $arg1 = shift (@ARGV); # Get file ID
 $opt{$opt_in} = $arg1; # Default this as the input
}
elsif ($numargs > 1)
{
 # Too many arguments specified
 print STDERR "ERROR: Too many arguments specified ($numargs), use --$opt_help for assistance\n";
 exit ($ercf_user);
}
#
# Check input file
if ($opt{$opt_in})
{
 # See if the specified input file exists
 if (! -f "$opt{$opt_in}")
 {
  $opt{$opt_in} .= '.' . "$inputext";
  if (!-f "$opt{$opt_in}")
  {
   print STDERR "ERROR: Input file '$opt{$opt_in}' not found, use --$opt_help for assistance\n";
   exit ($ercf_user);
  }
  else
  {
   print "Input file is '$opt{$opt_in}', extension added\n" if ($opt{$opt_verbose});
  }
 }
 else
 {
  print "Input file is '$opt{$opt_in}'\n" if ($opt{$opt_verbose});
 }
}
else
{
 # Cannot continue without some sort of input
 print STDERR "ERROR: No input file has been defined, use --$opt_help for assistance\n";
 exit ($ercf_user);
}
#
# Check output path
if ($opt{$opt_outdir})
{
 # See if the specified output directory exists
 if (! -d "$opt{$opt_outdir}")
 {
  print STDERR "ERROR: Specified output directory not found, use --$opt_help for assistance\n";
  exit ($ercf_user);
 }
 else
 {
  print "Output directory is '$opt{$opt_outdir}'\n" if ($opt{$opt_verbose});
 }
}
else
{
 # default it to current working dir if none
 $opt{$opt_outdir} = '.';
 print "Defaulting output directory to '$opt{$opt_outdir}'\n" if ($opt{$opt_verbose});
}
# Determine output leaf name
if ($opt{$opt_out})
{
 $outleaf = $opt{$opt_out}; # Use what the user supplied
}
else
{
 if ($defaultSTDOUT)
 {
  $opt{$opt_out} = 'STDOUT'; # Force output to STDOUT if so desired
  $outleaf = 'STDOUT';
 }
 else
 {
  # Derive output leaf name from input name
  $outleaf = $opt{$opt_in};
  $outleaf =~ s/^.*\///; # Isolate leaf
  $outleaf =~ s/\.$inputext$//; # Strip off default extension
  if ($outleaf !~ /\.$outpext$/)
  {
   $outleaf .= ".$outpext"; # Add default out extension if not there
  }
 }
 if ($opt{$opt_verbose})
 {
  print "Defaulting output to '$outleaf'\n";
 }
}
#
# Specific initialization following option gathering:
# (add your initialization items here)
#
# - - - - - - - - - - - - - -
# Main body of the code
#
if ($opt{$opt_verbose})
{
 # Show stuff if we want to
}
#
# Do the real work
($status,@inpfile) = &readfile("$opt{$opt_in}"); # Read input file
if ($status)
{
 print STDERR "ERROR: Unable to read input file '$opt{$opt_in}' ($status)\n$!\n";
 exit ($ercf_noinread);
}
#
# - - - input file read - - -
#
#
# Process file
$lineno = 0; # No input lines yet
$outlinecnt = 0; # No output lines yet
undef @content; # No output yet
#
# Spin through each line of the input file:
foreach $line (@inpfile)
{
 chomp ($line);
 $lineno++; # Bump input line number
 $outline = ''; # No output line yet
 # Echo input if we really need to:
 print "[$lineno] $line\n" if ($opt{$opt_veryveryverbose});
 #
 # - - do the work - -
 #
 # temporarily, no real work, just copy input to output
 $outline = $line; # Copy input to output
 $outlinecnt = &pushout(\@content,$outlinecnt,$outline); # Add this to output
 #
 # - - end of the work - -
 #
}
#
# - - - now write output file - - -
#
if (@content)
{
 $outlinecnt = scalar(@content); # Determine lines of output
}
else
{
 $outlinecnt = 0; # no output
}
if ($outlinecnt)
{
 if ($opt{$opt_verbose})
 {
  print "There are $outlinecnt lines of output\n";
 }
 # Write output
 if ("$opt{$opt_outdir}" eq '.')
 {
  $outpfile = "$outleaf"; # Use simple filename
 }
 else
 {
  $outpfile = "$opt{$opt_outdir}/$outleaf"; # Make outname in its dir
 }
 if (! -f $outpfile ||
     $opt{$opt_replace})
 {
  if ("$opt{$opt_in}" eq "$outpfile")
  {
   # oops, output is the same as the input, protect input against bad writes
   if ($opt{$opt_verbose})
   {
    print "Renaming input '$opt{$opt_in}' to '$opt{$opt_in}.$bakext' temporarily\n";
   }
   rename ("$opt{$opt_in}", "$opt{$opt_in}.$bakext") ;
  }
  ($status,$lines) = &writefile("$outpfile",@content); 
  if (! $status)
  {
   exit ($ercf_noopmake);
  }
  elsif ("$opt{$opt_in}" eq "$outpfile")
  {
   if (! $opt{$opt_keep})
   {
    # Wrote output OK, but had saved input and we don't need to
    if ($opt{$opt_verbose})
    {
     print "Deleting input file backup '$opt{$opt_in}.$bakext'\n";
    }
    unlink ("$opt{$opt_in}.$bakext") ;
   }
   elsif ($opt{$opt_verbose})
   {
    print "Kept input file as '$opt{$opt_in}.$bakext'\n";
   }
  }
 }
 else
 {
  print STDERR "ERROR: Output file '$outpfile' exists, use --$opt_replace to overwrite\n";
  exit ($ercf_opexist);
 }
}
#
# - - - - - - - - - - - - - -
#
exit ($ercf_ok); # Whew, must be OK
###
# - - - - - - - - - - - subroutines - - - - - - -
# Local subroutines
# ----------
# Standard subroutines
# ----------
# Add string to output array
# $outlinecnt = &pushout(\@content,$outlinecnt,"string");
sub pushout
{
 my ($contref,$outlinecnt,$outline) = @_;

 if ($outline)
 {
  push (@$contref,$outline); # Add this to the output file
  $outlinecnt++; # Bump output lines
 }
 return ($outlinecnt);
}
# ----------
# Read the designated file into @tmp
# ($status,@tmp) = &readfile("pathname");
# Where $status = 0 if OK
sub readfile
{
 my ($pathname) = @_;
 my (@tmp);

 # Open the input file and read its contents
 if (! open (FN, "<$pathname"))
 {
  print STDERR  "$ermcf{$ercf_user} file \"$pathname\" ($!)-- skipped\n" unless ($opt{$opt_quiet});
  return ($ercf_user,@tmp);
 }
 @tmp = <FN>;
 close (FN);
 # -- all of file read now
 return ($ercf_ok,@tmp);
}
# ----------
#-----------------------
# Write contents to identified file
# (or just write to STDOUT if that is the "$filename")
#  @content = array of the content lines
#  ($status,$lines) = &writefile("$filename",@content);
#  $status  = TRUE if read was good
#  $lines   = number of lines in the results
sub writefile
{
 my ($filename,@content) = @_;
 my ($line,$msg);
 my ($status,$lineno);

 $status = $false;
 $lineno = 0;
 $msg = '';

 if ($filename eq 'STDOUT')
 {
  # Just write this to STDOUT:
  foreach $line (@content)
  {
   chomp ($line);
   print "$line\n";
   $lineno++; # Bump line count
  }
 }
 else
 {
  # Now write the file
  if (!open (WRITEFL, ">$filename"))
  {
   $msg = "ERROR: unable to open $filename\n$!\n";
   print STDERR "$msg\n"; # Dispatch this error
  }
  else
  {
   foreach $line (@content)
   {
    chomp ($line);
    print WRITEFL "$line\n";
    $lineno++; # Bump line count
   }
   close (WRITEFL);
   $status = $true; # Show we had a good write
  }
 }
 return ($status,$lineno);
}
# ----------
# Print syntax message
sub syntax_message
{
 my ($progname);
 my ($key);
 my ($toolid);

 chomp ($progname = `basename $0`);
 if (! $opt{$opt_syntax})
 {
  print STDERR  qq+
Version $versn

Name: $progname - This program name
   What it does.+;
 }
 if (! $opt{$opt_syntax})
 {
  print STDERR  qq+

Syntax:

+;
 }
 # Always show this line:
 print STDERR "   $progname  [ options ]  [filename]\n";
 if ($opt{$opt_syntax} && $opt{$opt_verbose})
 {
  print STDERR  qq+
   Operational options:
   --$opt_in=f,--$opt_keep,--$opt_out=f,--$opt_outdir=d+;
if (! $replacedefault)
{
  print STDERR  qq+,--$opt_replace+;
}
  print STDERR  qq+
   Assistance options:
   --$opt_help,--$opt_quiet,--$opt_showerror,--$opt_syntax,--$opt_verbose,--$opt_version,--$opt_veryverbose,--$opt_veryveryverbose
+;
 }
 if (! $opt{$opt_syntax})
 {
  print STDERR  qq+
The positional argument 'filename' is optional, and may be replaced with
a specific optional argument below.+;
 }
 if (! $opt{$opt_syntax})
 {
  print STDERR  qq+
If present, the positional argument is assumed to be:

 *  filename from which to read the input data
    If the specified file does not exist and does not end with the default
    extension ".$inputext", then that extension will be added and input
    will be attempted from the resulting extended name

Only one positional argument is permitted.+;
 }
 if (! $opt{$opt_syntax})
 {
  print STDERR  qq+

Where 'options' are:
+;

  print STDERR  qq+
   --$opt_in=filename
       Name of the input file, if not provided by a positional argument
   --$opt_keep, -k
       Keep the backed up input file if it was needed.
       If the output file name is the same as the input file name, then the
       input file is saved under the same name, but with extension '.$bakext'
       before the output is written. If the output is written correctly,
       then the backup file is deleted unless option --$opt_keep is specified
   --$opt_out=filename
       Use this argument as the name of the output file+;
if ($defaultSTDOUT)
{
  print STDERR  qq+
       (if output to the default STDOUT is not desired)+;
}
else
{
  print STDERR  qq+
       (if filename is STDOUT, the output is written to STDOUT, not to a file)
       (default is to use the input file name plus the extension '$outpext')+;
}
  print STDERR  qq+
   --$opt_outdir=directory, --outd=directory
       Place the resulting output file(s) in the specified directory
       (default is to put them into the current working directory)+;
if ($defaultSTDOUT)
{
  print STDERR  qq+
       (requires --$opt_out or output is written to file STDOUT in this dir)+;
}
if (! $replacedefault)
{
 # Only show this if it is not defaulted to "true"
  print STDERR  qq+
   --$opt_replace, -r
       Replace an existing output file with the new data
       (default is to not over write an existing output file)+;
}
  print STDERR  qq+

  Help and assistance options:

   --$opt_help, -h
       Print this help message
       (use --$opt_verbose or --$opt_veryverbose for extended help)
   --$opt_quiet, -q
       Quiet mode--don't show advisory info or warnings unless verbose
       is also selected (errors still are shown)
   --$opt_showerror, --shoerr, --se, -e
       Show brief descriptions of error exit codes from this routine
   --$opt_syntax
       Only show the syntax line of this help, not all the other info
       (use with --$opt_verbose for slightly more syntax info)
   --$opt_verbose, -v
       Verbose mode, show some diagnostics as well as the input path read
       and the output path written (or show more --help info)
   --$opt_version
       Display the version number of this routine
   --$opt_veryverbose, --vv
       Very verbose mode (implies --$opt_verbose), show more information
       in addition to all --$opt_verbose info
   --$opt_veryveryverbose, --vvv
       Very very verbose mode (implies --$opt_veryverbose), show more information
       in addition to all --$opt_veryverbose info
+;
 }
 if (! $opt{$opt_syntax})
 {
  print STDERR  qq+
Additional information:

 1) 
+;
 }

 if ($opt{$opt_veryverbose} && ! $opt{$opt_syntax})
 {
  &show_error_codes(%ermcf); # Sho error codes
 }
 if (! $opt{$opt_syntax})
 {
  print STDERR  qq+
EXAMPLES

   $progname
+;
 }
}

# ----------
# Sho error codes
#  &show_error_codes(%ermcf);
# where: %ermcf is a hash of the error exits and reasons
sub show_error_codes
{
 my (%ermcf) = @_;
 my ($key);

 print STDERR  qq+
Error exit codes:
+;
 foreach $key (sort keys %ermcf)
 {
  printf STDERR ("%5s  =  %s\n",$key,$ermcf{$key});
 }
}
# ----------
